#include "stack.h"
#include "teststack.h"

#include <cppunit/CompilerOutputter.h>
// #include <cppunit/XmlOutputter.h>
#include <cppunit/ui/text/TextTestRunner.h>
#include <cppunit/extensions/TestFactoryRegistry.h>

int main(void)
{
  /* Test-Runner erzeugen */
  CppUnit::TextTestRunner runner;
 
  /* TestSuite erzeugen */
  CppUnit::Test *suite = CppUnit::TestFactoryRegistry::getRegistry().makeTest();

  runner.addTest( suite );

  /* Outputformatierung festlegen */
  runner.setOutputter( new CppUnit::CompilerOutputter( &runner.result(), std::cerr ) );
//  runner.setOutputter( new CppUnit::XmlOutputter( &runner.result(), std::cerr ) );

  /* Tests durchführen 
  ** und 0 oder im Fehlerfall 1 zurückmelden */
  return runner.run() ? 0 : 1;
}