#include "file.h"

File::File( char const * filename )
{
  Handle = fopen( filename, "r+" );
  Filename = filename;
  
  if( Handle )
  {
    fseek( Handle, 0, SEEK_END );
    Size = ftell( Handle );
    fseek( Handle, 0, SEEK_SET );
  }
}

bool File::Read( char * buffer, int size )
{
  if( Handle )
    return 1 == fread( buffer, size, 1, Handle ); 
    
  return false;
}

bool File::Write( char * buffer, int size )
{
  if( Handle )
    return 1 == fwrite( buffer, size, 1, Handle );
    
  return false;
}
 
unsigned int File::GetSize()
{
  if( !Handle )
    return -1;

  return Size;
}
 
bool File::Close()
{
  if( Handle )
  {
  	fclose( Handle );
  	Handle = NULL;
  	return true;
  }
  
  return false;
}
